/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.util.CSVRecord;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.hsc.common.util.PIIODescriptionLookup;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.snia.wbem.cim.UnsignedInt16;

public class PIFeatureCodeLookup {
    private String m_configFilePath;
    private HashMap m_classCodeMap = new HashMap();
    public static final int WILDCARD = -1;
    private static final int UNKNOWN_FC = -2;
    private static final int NO_FC = -3;
    private static final char PARSE_COMMENT = '#';
    private static final char PARSE_WILD = '*';
    private static final char PARSE_INCOMPLETE = 'x';
    private static final char PARSE_NO_FC = '-';
    private static final char PARSE_UNKNOWN_FC = '?';
    private static PIFeatureCodeLookup s_singletonInstance = null;

    public static synchronized PIFeatureCodeLookup getInstance() {
        if (s_singletonInstance == null) {
            System.out.println("Creating PIFeatureCodeLookup instance!");
            PIFeatureCodeLookup pIFeatureCodeLookup = new PIFeatureCodeLookup("/opt/hsc/data/HscPciFeatureCodeInfo");
            pIFeatureCodeLookup.parseConfigFile();
            s_singletonInstance = pIFeatureCodeLookup;
        }
        return s_singletonInstance;
    }

    private PIFeatureCodeLookup(String string) {
        this.m_configFilePath = string;
    }

    private void parseConfigFile() {
        String[] stringArray = new String[6];
        int[] nArray = new int[6];
        int n = 0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.m_configFilePath));
            String string = "";
            while (string != null) {
                boolean bl = false;
                string = bufferedReader.readLine();
                ++n;
                if (string == null || string.length() <= 0 || string.charAt(0) == '#') continue;
                try {
                    Object object;
                    int n2;
                    CSVRecord cSVRecord = new CSVRecord(string);
                    Object[] objectArray = cSVRecord.toArray();
                    if (objectArray == null || objectArray.length < 12) continue;
                    for (n2 = 0; n2 < 6; ++n2) {
                        object = (String)objectArray[n2];
                        stringArray[n2] = ((String)object).lastIndexOf(45) >= 0 ? null : (((String)object).lastIndexOf(63) >= 0 ? null : object);
                    }
                    for (n2 = 0; n2 < 6; ++n2) {
                        object = (String)objectArray[n2 + 6];
                        if (((String)object).lastIndexOf(120) >= 0) {
                            bl = true;
                            continue;
                        }
                        nArray[n2] = ((String)object).lastIndexOf(42) >= 0 ? -1 : Integer.parseInt((String)object, 16);
                    }
                    if (bl) continue;
                    PCIConfigDataEntry pCIConfigDataEntry = new PCIConfigDataEntry(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5]);
                    object = new Integer(nArray[4]);
                    if (!this.m_classCodeMap.containsKey(object)) {
                        this.m_classCodeMap.put(object, new LinkedList());
                    }
                    LinkedList linkedList = (LinkedList)this.m_classCodeMap.get(object);
                    linkedList.add(pCIConfigDataEntry);
                }
                catch (Exception exception) {
                    System.err.println("Exception on line " + n + ": " + exception);
                    exception.printStackTrace();
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("IOException on line " + n + ": " + iOException);
        }
    }

    private final void listFinderHelper(PCIConfigDataEntry pCIConfigDataEntry, List list, List list2) {
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PCIConfigDataEntry pCIConfigDataEntry2 = (PCIConfigDataEntry)iterator.next();
                if (!pCIConfigDataEntry2.isMatchingPCIConfig(pCIConfigDataEntry)) continue;
                list2.add(pCIConfigDataEntry2);
            }
        }
    }

    public void lookupFeatureCode(UnsignedInt16 unsignedInt16, int n, int n2, int n3, int n4, int n5, int n6, List list, List list2, List list3) {
        ArrayList arrayList = new ArrayList();
        PCIConfigDataEntry pCIConfigDataEntry = new PCIConfigDataEntry(null, null, null, null, null, null, n, n2, n3, n4, n5, n6);
        Integer n7 = new Integer(n5);
        LinkedList linkedList = (LinkedList)this.m_classCodeMap.get(new Integer(n5));
        this.listFinderHelper(pCIConfigDataEntry, linkedList, arrayList);
        LinkedList linkedList2 = (LinkedList)this.m_classCodeMap.get(new Integer(-1));
        this.listFinderHelper(pCIConfigDataEntry, linkedList2, arrayList);
        Collections.sort(arrayList, new PCIConfigDataEntryComparator());
        boolean bl = PIHscUtil.isISeriesBrand(unsignedInt16) || unsignedInt16 == null;
        boolean bl2 = !PIHscUtil.isISeriesBrand(unsignedInt16);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            PCIConfigDataEntry pCIConfigDataEntry2 = (PCIConfigDataEntry)iterator.next();
            if (list != null) {
                if (bl && pCIConfigDataEntry2.iOS400Fc != null && !list.contains(pCIConfigDataEntry2.iOS400Fc)) {
                    list.add(pCIConfigDataEntry2.iOS400Fc);
                }
                if (bl2 && pCIConfigDataEntry2.pOS400Fc != null && !list.contains(pCIConfigDataEntry2.pOS400Fc)) {
                    list.add(pCIConfigDataEntry2.pOS400Fc);
                }
            }
            if (list2 != null) {
                if (bl && pCIConfigDataEntry2.iLinuxFc != null && !list2.contains(pCIConfigDataEntry2.iLinuxFc)) {
                    list2.add(pCIConfigDataEntry2.iLinuxFc);
                }
                if (bl2 && pCIConfigDataEntry2.pLinuxFc != null && !list2.contains(pCIConfigDataEntry2.pLinuxFc)) {
                    list2.add(pCIConfigDataEntry2.pLinuxFc);
                }
            }
            if (list3 == null) continue;
            if (bl && pCIConfigDataEntry2.iAIXFc != null && !list3.contains(pCIConfigDataEntry2.iAIXFc)) {
                list3.add(pCIConfigDataEntry2.iAIXFc);
            }
            if (!bl2 || pCIConfigDataEntry2.pAIXFc == null || list3.contains(pCIConfigDataEntry2.pAIXFc)) continue;
            list3.add(pCIConfigDataEntry2.pAIXFc);
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string;
            Iterator iterator;
            PIFeatureCodeLookup pIFeatureCodeLookup = PIFeatureCodeLookup.getInstance();
            UnsignedInt16 unsignedInt16 = null;
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            PIIODescriptionLookup pIIODescriptionLookup = new PIIODescriptionLookup(unsignedInt16);
            pIFeatureCodeLookup.lookupFeatureCode(unsignedInt16, 4116, 49, 0, 0, 65280, 2, arrayList, arrayList2, arrayList3);
            System.out.println("OS/400 matches:");
            if (arrayList.size() == 0) {
                System.out.println("    no matches");
            } else {
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    System.out.println("    " + string + ": " + pIIODescriptionLookup.lookupFeatureCode(string));
                }
            }
            System.out.println("Linux matches:");
            if (arrayList2.size() == 0) {
                System.out.println("    no matches");
            } else {
                iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    System.out.println("    " + string + ": " + pIIODescriptionLookup.lookupFeatureCode(string));
                }
            }
            System.out.println("AIX matches:");
            if (arrayList3.size() == 0) {
                System.out.println("    no matches");
            } else {
                iterator = arrayList3.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    System.out.println("    " + string + ": " + pIIODescriptionLookup.lookupFeatureCode(string));
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private class PCIConfigDataEntryComparator
    implements Comparator {
        private PCIConfigDataEntryComparator() {
        }

        public int compare(Object object, Object object2) {
            PCIConfigDataEntry pCIConfigDataEntry = (PCIConfigDataEntry)object;
            PCIConfigDataEntry pCIConfigDataEntry2 = (PCIConfigDataEntry)object2;
            if (pCIConfigDataEntry.rank < pCIConfigDataEntry2.rank) {
                return -1;
            }
            if (pCIConfigDataEntry.rank == pCIConfigDataEntry2.rank) {
                return 0;
            }
            return 1;
        }
    }

    public class PCIConfigDataEntry {
        public String iOS400Fc;
        public String iLinuxFc;
        public String iAIXFc;
        public String pOS400Fc;
        public String pLinuxFc;
        public String pAIXFc;
        public int vendorId;
        public int deviceId;
        public int subsystemVendorId;
        public int subsystemDeviceId;
        public int classCode;
        public int revisionId;
        public byte rank;

        PCIConfigDataEntry(String string, String string2, String string3, String string4, String string5, String string6, int n, int n2, int n3, int n4, int n5, int n6) {
            this.iOS400Fc = string;
            this.iLinuxFc = string2;
            this.iAIXFc = string3;
            this.pOS400Fc = string4;
            this.pLinuxFc = string5;
            this.pAIXFc = string6;
            this.rank = 0;
            this.vendorId = n;
            if (this.vendorId == -1) {
                this.rank = (byte)(this.rank + 1);
            }
            this.deviceId = n2;
            if (this.deviceId == -1) {
                this.rank = (byte)(this.rank + 1);
            }
            this.subsystemVendorId = n3;
            if (this.subsystemVendorId == -1) {
                this.rank = (byte)(this.rank + 1);
            }
            this.subsystemDeviceId = n4;
            if (this.subsystemDeviceId == -1) {
                this.rank = (byte)(this.rank + 1);
            }
            this.classCode = n5;
            if (this.classCode == -1) {
                this.rank = (byte)(this.rank + 1);
            }
            this.revisionId = n6;
            if (this.revisionId == -1) {
                this.rank = (byte)(this.rank + 1);
            }
        }

        public String toString() {
            return this.iOS400Fc + "," + this.iLinuxFc + "," + this.iAIXFc + "," + this.pOS400Fc + "," + this.pLinuxFc + "," + this.pAIXFc + "," + (this.vendorId == -1 ? "*" : Integer.toHexString(this.vendorId)) + "," + (this.deviceId == -1 ? "*" : Integer.toHexString(this.deviceId)) + "," + (this.subsystemVendorId == -1 ? "*" : Integer.toHexString(this.subsystemVendorId)) + "," + (this.subsystemDeviceId == -1 ? "*" : Integer.toHexString(this.subsystemDeviceId)) + "," + (this.classCode == -1 ? "*" : Integer.toHexString(this.classCode)) + "," + (this.revisionId == -1 ? "*" : Integer.toHexString(this.revisionId)) + ",rank=" + this.rank;
        }

        public boolean isMatchingPCIConfig(PCIConfigDataEntry pCIConfigDataEntry) {
            return !(this.vendorId != -1 && pCIConfigDataEntry.vendorId != this.vendorId || this.deviceId != -1 && pCIConfigDataEntry.deviceId != this.deviceId || this.subsystemVendorId != -1 && pCIConfigDataEntry.subsystemVendorId != this.subsystemVendorId || this.subsystemDeviceId != -1 && pCIConfigDataEntry.subsystemDeviceId != this.subsystemDeviceId || this.classCode != -1 && pCIConfigDataEntry.classCode != this.classCode || this.revisionId != -1 && pCIConfigDataEntry.revisionId != this.revisionId);
        }
    }
}

